<?php
	/*Database Connection*/
	include("dbconnection.php");
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>MySQL - Print, PDF, Excel and CSV Export Tools</title>
    <!-- favicon-->
	<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
	<link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <!-- Bootstrap css-->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">      
	<!-- font-awesome css-->
    <link href="assets/css/font-awesome.min.css" rel="stylesheet"> 	
	<!-- print css-->
    <link href="assets/css/print.min.css" rel="stylesheet">    
	<!-- style -->
    <link href="style.css" rel="stylesheet">
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5shiv.min.js"></script>
      <script src="assets/js/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="header">
					<div class="logo">
						<a href="index.php"><img src="images/logo.png"/></a>
					</div>
					<h2>MySQL - Print, PDF, Excel and CSV Export Tools</h2>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-3">
				<div class="panel-area">
					<div class="panel-header">
						<div class="header-title">Export Functionalities</div>
					</div>
					<div class="panel-content">
						<ul class="nav nav-tabs nav-list">
							<li class="active"><a data-toggle="tab" href="#Basic">Basic</a></li>
							<li><a data-toggle="tab" href="#RowGrouping">Row Grouping</a></li>
							<li><a data-toggle="tab" href="#HeaderRowsColumnsMerge">Header (Rows and Columns Merge)</a></li>
							<li><a data-toggle="tab" href="#AutofilterRangeofCells">Autofilter Range of Cells just Excel Export</a></li>
							<li><a data-toggle="tab" href="#FormulaCalculations">Formula Calculations just Excel Export</a></li>
							<li><a data-toggle="tab" href="#ProtectedUnprotected">Protected and Unprotected on Cells just Excel Export</a></li>
						</ul>
					</div>
					
				</div>
			</div>
			<div class="col-md-9">
				<div class="panel-area">
					<div class="tab-content">
						<div id="Basic" class="tab-pane fade in active">
							<div class="panel-header">
								<div class="inner-panel">
									<h5 class="rules-title">Basic</h5>
									<ul class="icon-list">
										<li class="print"><a title="print" target="_blank" href="basic-print.php"><i class="fa fa-print"></i></a></li>
										<li class="pdf"><a target="_blank" title="pdf" href="basic-pdf.php"><i class="fa fa-file-pdf-o"></i></a></li>
										<li class="excel"><a title="excel" href="basic-excel.php"><i class="fa fa-file-excel-o"></i></a></li>
										<li class="csv"><a title="csv" href="basic-csv.php"><img src="images/icon-csv.png" alt="" /></a></li>
									</ul>
								</div>
							</div>
							<div class="panel-content">
								<div id="printHtmlBasic" class="table-responsive">
									<table class="table table-bordered table-hover" cellspacing="0" width="100%">
										<thead> 
											<tr>
												<th class="txt-center" width="5%">#</th>
												<th width="35%">Item Name</th> 
												<th width="15%">Item Code</th> 
												<th width="15%">Date</th> 
												<th class="txt-right" width="15%">Price</th> 
												<th class="txt-right" width="15%">Quantity</th> 
											</tr> 
										</thead> 
										<tbody>
											<?php
												/*sql*/
												$sql = "SELECT id, ItemName, ItemCode,`Date`, Price, Quantity 
												FROM excelexport ORDER BY ItemName;";
												$result = $pdo->query($sql);
												$i=1; 
												while ($aRow = $result->fetch(PDO::FETCH_ASSOC)){
											?>
											<tr> 
												<td class="txt-center"><?php echo $i++; ?></td> 
												<td><?php echo $aRow['ItemName']; ?></td> 
												<td><?php echo $aRow['ItemCode']; ?></td> 
												<td><?php echo $aRow['Date']; ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Price'],2); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Quantity']); ?></td>
											</tr> 
											<?php }	?>
										</tbody> 
									</table>
								</div>
							</div>
						</div><!--end of Simple Excel Export-->

						<div id="RowGrouping" class="tab-pane fade">
							<div class="panel-header">
								<div class="inner-panel">
									<h5 class="rules-title">Row Grouping</h5>
									<ul class="icon-list">
										<li class="print"><a title="print" target="_blank" href="row-grouping-print.php"><i class="fa fa-print"></i></a></li>
										<li class="pdf"><a target="_blank" title="pdf" href="row-grouping-pdf.php"><i class="fa fa-file-pdf-o"></i></a></li>
										<li class="excel"><a title="excel" href="row-grouping-excel.php"><i class="fa fa-file-excel-o"></i></a></li>
									</ul>
								</div>
							</div>
							<div class="panel-content">
								<div id="printHtmlRowGrouping" class="table-responsive">
									<table class="table table-bordered table-hover" cellspacing="0" width="100%">
										<thead>
											<tr>
												<th class="txt-center" width="5%">#</th>
												<th width="35%">Item Name</th> 
												<th width="20%">Item Code</th> 
												<th class="txt-right" width="20%">Price</th> 
												<th class="txt-right" width="20%">Quantity</th>  
											</tr>
										</thead>
										<tbody>
											<?php
											/*sql*/
											$sql = "SELECT id, ItemName, ItemCode,`Date`, Price, Quantity FROM excelexport;";
											$result = $pdo->query($sql);
											$tempDate = '';
											$i=1;
											while ($aRow = $result->fetch(PDO::FETCH_ASSOC)){
												if($tempDate!=$aRow['Date']) {
											?>
											<tr> 
												<td style="background-color:#f3faf6;" colspan="7"><?php echo $aRow['Date']; ?></td> 
											</tr> 
											<?php 
												$tempDate=$aRow['Date'];
												}
											?>
											<tr> 
												<td class="txt-center"><?php echo $i++; ?></td> 
												<td><?php echo $aRow['ItemName']; ?></td> 
												<td><?php echo $aRow['ItemCode']; ?></td>  
												<td class="txt-right"><?php echo number_format($aRow['Price'],2); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Quantity']); ?></td> 
											</tr> 
											<?php }	?>
											
										</tbody>
									</table>
								</div>
							</div>
						</div><!--end of Row Grouping-->						
						
						<div id="HeaderRowsColumnsMerge" class="tab-pane fade">
							<div class="panel-header">
								<div class="inner-panel">
									<h5 class="rules-title">Header (Rows and Columns Merge)</h5>
									<ul class="icon-list">
										<li class="print"><a title="print" target="_blank" href="header-rows-columns-merge-print.php"><i class="fa fa-print"></i></a></li>
										<li class="pdf"><a target="_blank" title="pdf" href="header-rows-columns-merge-pdf.php"><i class="fa fa-file-pdf-o"></i></a></li>
										<li class="excel"><a title="excel" href="header-rows-columns-merge-excel.php"><i class="fa fa-file-excel-o"></i></a></li>
									</ul>
								</div>
							</div>
							<div class="panel-content">
								<div class="table-responsive">
									<table id="printHtmlRowsColumnsMerge" class="table table-bordered table-hover" cellspacing="0" width="100%">
										<thead>
											<tr>
												<th rowspan="2" class="txt-center" width="5%" style="vertical-align:middle;">#</th>
												<th rowspan="2" width="35%" style="vertical-align:middle;">Row Merge</th> 
												<th colspan="2" width="30%" class="txt-center">Column Merge 1</th> 
												<th colspan="2" width="30%" class="txt-center">Column Merge 2</th> 
											</tr>
											<tr>
												<th width="15%">Column 2</th> 
												<th width="15%">Column 3</th> 
												<th class="txt-right" width="15%">Column 4</th> 
												<th class="txt-right" width="15%">Column 5</th> 
											</tr>
										</thead>
										<tbody>
											<?php
												/*sql*/
												$sql = "SELECT id, ItemName, ItemCode,`Date`, Price, Quantity 
												FROM excelexport ORDER BY ItemName;";
												$result = $pdo->query($sql);
												$i=1; 
												while ($aRow = $result->fetch(PDO::FETCH_ASSOC)){
											?>
											<tr> 
												<td class="txt-center"><?php echo $i++; ?></td> 
												<td><?php echo $aRow['ItemName']; ?></td> 
												<td><?php echo $aRow['ItemCode']; ?></td> 
												<td><?php echo $aRow['Date']; ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Price'],2); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Quantity']); ?></td> 
											</tr> 
											<?php }	?>
											
										</tbody>
									</table>
								</div>
							</div>
						</div><!--end of Header (Rows and Columns Merge)-->						
						
						<div id="AutofilterRangeofCells" class="tab-pane fade">
							<div class="panel-header">
								<div class="inner-panel">
									<h5 class="rules-title">Autofilter Range of Cells just Excel Export</h5>
									<ul class="icon-list">
										<li class="excel"><a title="excel" href="autofilter-range-of-cells.php"><i class="fa fa-file-excel-o"></i></a></li>
									</ul>
								</div>
							</div>
							<div class="panel-content">
								<div class="table-responsive">
									<table class="table table-bordered table-hover" cellspacing="0" width="100%">
										<thead> 
											<tr>
												<th class="txt-center" width="5%">#</th>
												<th width="35%">Item Name</th> 
												<th width="15%">Item Code</th> 
												<th class="txt-center" width="15%">Date</th> 
												<th class="txt-right" width="15%">Price</th> 
												<th class="txt-right" width="15%">Quantity</th> 
											</tr> 
										</thead> 
										<tbody>
											<?php
												/*sql*/
												$sql = "SELECT id, ItemName, ItemCode,`Date`, Price, Quantity 
												FROM excelexport ORDER BY ItemName;";
												$result = $pdo->query($sql);
												$i=1; 
												while ($aRow = $result->fetch(PDO::FETCH_ASSOC)){
											?>
											<tr> 
												<td class="txt-center"><?php echo $i++; ?></td> 
												<td><?php echo $aRow['ItemName']; ?></td> 
												<td><?php echo $aRow['ItemCode']; ?></td> 
												<td class="txt-center"><?php echo $aRow['Date']; ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Price'],2); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Quantity']); ?></td>
											</tr> 
											<?php }	?>
										</tbody> 
									</table>
								</div>
							</div>
						</div><!--end of Row Merge Excel Export-->
						
						<div id="FormulaCalculations" class="tab-pane fade">
							<div class="panel-header">
								<div class="inner-panel">
									<h5 class="rules-title">Formula Calculations just Excel Export</h5>
									<ul class="icon-list">
										<li class="excel"><a title="excel" href="formula-calculations-excel-export.php"><i class="fa fa-file-excel-o"></i></a></li>
									</ul>
								</div>
							</div>
							<div class="panel-content">
								<div class="table-responsive">
									<table class="table table-bordered table-hover" cellspacing="0" width="100%">
										<thead> 
											<tr>
												<th class="txt-center" width="4%">#</th>
												<th width="30%">Cell1</th> 
												<th class="txt-right" width="10%">Cell2</th> 
												<th class="txt-right" width="8%">Cell3</th> 
												<th class="txt-right" width="11%">(Cell2*Cell3)</th> 
												<th class="txt-right" width="11%">(Cell2+Cell3)</th> 
												<th class="txt-right" width="15%">(Cell2-Cell3)</th> 
												<th class="txt-right" width="11%">(Cell2/Cell3)</th> 
											</tr> 
										</thead> 
										<tbody>
											<?php
												/*sql*/
												$sql = "SELECT id, ItemName, ItemCode,`Date`, Price, Quantity 
												FROM excelexport ORDER BY ItemName;";
												$result = $pdo->query($sql);
												$i=1; 
												while ($aRow = $result->fetch(PDO::FETCH_ASSOC)){
											?>
											<tr> 
												<td class="txt-center"><?php echo $i++; ?></td> 
												<td><?php echo $aRow['ItemName']; ?></td>  
												<td class="txt-right"><?php echo number_format($aRow['Price']); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Quantity']); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Price']*$aRow['Quantity']); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Price']+$aRow['Quantity']); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Price']-$aRow['Quantity']); ?></td> 
												<td class="txt-right"><?php echo number_format(($aRow['Price']/$aRow['Quantity']),2); ?></td> 
											</tr> 
											<?php }	?>
										</tbody> 
									</table>
								</div>
							</div>
						</div><!--end of Formula Calculations-->
						
						<div id="ProtectedUnprotected" class="tab-pane fade">
							<div class="panel-header">
								<div class="inner-panel">
									<h5 class="rules-title">Protected and Unprotected on Cells just Excel Export</h5>
									<ul class="icon-list">
										<li class="excel"><a title="excel" href="protected-and-unprotected-on-cells.php"><i class="fa fa-file-excel-o"></i></a></li>
									</ul>
								</div>
							</div>
							<div class="panel-content">
								<div class="table-responsive">
									<table class="table table-bordered table-hover" cellspacing="0" width="100%">
										<thead>
											<tr>
												<th colspan="2" class="txt-center" width="34%">Protected Cell</th> 
												<th colspan="2" class="txt-center" width="18%">Unprotected Cell</th> 
												<th colspan="4" class="txt-center" width="48%">Protected Cell</th> 
											</tr>
											<tr>
												<th class="txt-center" width="4%">#</th>
												<th width="30%">Cell1</th> 
												<th class="txt-right" width="10%">Cell2</th> 
												<th class="txt-right" width="8%">Cell3</th> 
												<th class="txt-right" width="11%">(Cell2*Cell3)</th> 
												<th class="txt-right" width="11%">(Cell2+Cell3)</th> 
												<th class="txt-right" width="15%">(Cell2-Cell3)</th> 
												<th class="txt-right" width="11%">(Cell2/Cell3)</th> 
											</tr> 
										</thead> 
										<tbody>
											<?php
												/*sql*/
												$sql = "SELECT id, ItemName, ItemCode,`Date`, Price, Quantity 
												FROM excelexport ORDER BY ItemName;";
												$result = $pdo->query($sql);
												$i=1; 
												while ($aRow = $result->fetch(PDO::FETCH_ASSOC)){
											?>
											<tr> 
												<td class="txt-center"><?php echo $i++; ?></td> 
												<td><?php echo $aRow['ItemName']; ?></td>  
												<td class="txt-right"><?php echo number_format($aRow['Price']); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Quantity']); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Price']*$aRow['Quantity']); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Price']+$aRow['Quantity']); ?></td> 
												<td class="txt-right"><?php echo number_format($aRow['Price']-$aRow['Quantity']); ?></td> 
												<td class="txt-right"><?php echo number_format(($aRow['Price']/$aRow['Quantity']),2); ?></td> 
											</tr> 
											<?php }	?>
										</tbody> 
									</table>
								</div>
							</div>
						</div><!--end of Protected and Unprotected on Cells-->
						
					</div>
				</div>
			</div>
		</div>
	</div>
	
    <!-- jQuery plugins -->
    <script src="assets/js/jquery-3.2.1.min.js"></script>
    <!-- bootstrap js -->
    <script src="assets/js/bootstrap.min.js"></script>
	
  </body>
</html>